﻿
namespace Framework.Web.UI
{
    /// <summary>
    /// 入力コントロールのインターフェース
    /// </summary>
    public interface IInputControl
    {
        /// <summary>
        /// 検証結果
        /// </summary>
        bool IsValid { get; set; }

        /// <summary>
        /// 検証結果が無効なコントロールを返す。通常はthisでよいが、複合コントロールやユーザコントロールの場合は個別のコントロールを返す。
        /// </summary>
        /// <returns></returns>
        System.Web.UI.Control GetErrorControl();

        /// <summary>
        /// 値が入力されているかどうか。DefaultValueと同じ場合は入力されていないとみなす。
        /// </summary>
        /// <returns></returns>
        bool IsInputed();

        /// <summary>
        /// 入力値が空かどうか？
        /// </summary>
        /// <returns></returns>
        bool IsBlank();

        /// <summary>
        /// 入力値の検証
        /// </summary>
        /// <returns></returns>
        bool ValidateInput(bool dataTypeOnly);

        /// <summary>
        /// コントロールを検証結果を表す状態にする。
        /// </summary>
        /// <param name="isSuccess"></param>
        void SetValidateResult(bool isSuccess);

        /// <summary>
        /// 入力値をクリアする。
        /// </summary>
        void ClearInput();

        /// <summary>
        /// 入力された値を返す。
        /// </summary>
        /// <returns></returns>
        string GetInputValue();
    }
}
